% PresentImgProg.m 12,17,2003

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% EPI
%%% TR/TE/@ :3000/35/90
%%% FOV= 240*240
%%% voxel size: 3*3*5mm
%%% whole brain slices=21 slices 
%%% in-plane resolution=3mm*3mm 
%%% repetition= 72+3
%%% 3D high resolution anatomy scan(T1-weighted)
%%% 12blocks*12trials*1.5sec+6*1.5=216+9=225sec
%%% 640*480
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% prepare all stimuli %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% computer parameters

try
    clear all;
    pixelSize=0.0353; %degree/pixel
    LCDframeRate = 60; %Hz
    cd /Users/tancy/Dropbox/01_NTUProj/MatlabIntro/PresentImagDemo % current path

    % general present parameters 
    ITI=3.0; %second , the duration between stimuli
    dur=2.0; %second the duration of one stimuli
    nInitWait=9; %second initial waiting time (put some stimuli to get subjects's stable state) 

    % get sequence
    [NULL, seti]=sort(rand(5,1)); %seq of initwait sti
    seti=mod(seti,5)+1; 

    % read data
    cd /Users/tancy/Dropbox/01_NTUProj/MatlabIntro/PresentImagDemo/Stimuli

    for h = 1:5
         fname=['HFW','10',num2str(h),'.bmp'];
         temp=imread(fname,'bmp');
         initSti(:,:,h)=255-double(temp(:,:,1));
       end

    bgImage=zeros(size(temp(:,:,1)));   

    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     %%% Run Experiment  %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    % Eye Catching 
    [win1 rect]=Screen(0,'OpenWindow',0); 
    HideCursor % hide mouse 
    centerx=rect(3)/2+1; % put image on the screen center
    centery=rect(4)/2+1; 

    %Screen(win1,'TextFont','arial'); 
    %Screen(win1,'TextSize',14); 
    Screen(win1,'DrawText','Ready',centerx-20,centery,255); 
    Screen(win1, 'Flip');
    % WaitSecs(3);
    %t0=getsecs; % start to get time

    t0=KbWait; % demo use Waits until any key is down and returns the time (GetSecs)
    Screen(win1,'PutImage',bgImage);   
    Screen(win1,'FillOval',255,...
    [centerx-2,centery-2,centerx+2,centery+2]); % draw a fixation 

    % initWait
    t1=GetSecs; % start to get time
    for i = 1:5 %  initwait usually 2-3TR (start of each run)
       h=i;
       t2=GetSecs;
       testImage=initSti(:,:,seti(h)); 
       Screen(win1,'PutImage',testImage); 
       Screen(win1,'FillOval',255,[centerx-2,centery-2,centerx+2,centery+2]);
       Screen(win1, 'Flip');
       while(GetSecs-t2 < dur)
       end
       Screen(win1,'PutImage',bgImage);
       Screen(win1,'FillOval',255,[centerx-2,centery-2,centerx+2,centery+2]);
       Screen(win1, 'Flip');
        while(GetSecs-t2 < ITI) 
        end
    end 


    %GetSecs-t0
    GetSecs-t1
    %Clean up
    Screen(win1,'PutImage',ones(size(bgImage))*0);
    Screen('closeAll');
    

catch
    Screen('closeAll');
end